<?php
/*--------------------------------------------------------------
   Row.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Table;

use Gambio\Admin\Modules\Statistics\Model\Collections\TableRowFields;

class Row
{
    /**
     * @var TableRowFields
     */
    private $fields;
    
    
    /**
     * Constructor.
     */
    private function __construct(TableRowFields $fields)
    {
        $this->fields = $fields;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(TableRowFields $fields): self
    {
        return new self($fields);
    }
    
    
    /**
     * Return fields.
     */
    public function fields(): TableRowFields
    {
        return $this->fields;
    }
}